<?php
session_start();
require_once "db.php";

$db = new Database();
$conn = $db->connect();

$message = "";
$successName = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $name = trim($_POST["name"]);
    $position = trim($_POST["position"]);

    if ($name && $position && isset($_FILES["image"])) {

        $imageName = time() . "_" . basename($_FILES["image"]["name"]);
        $targetPath = "images/" . $imageName;

        if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetPath)) {

            $stmt = $conn->prepare(
                "INSERT INTO candidates (name, position, image) VALUES (?, ?, ?)"
            );
            $stmt->execute([$name, $position, $imageName]);

            $successName = $name;

        } else {
            $message = "image upload failed";
        }

    } else {
        $message = "all fields required";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Candidate</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif}
body{min-height:100vh;background:#eef6ff;display:flex;justify-content:center;padding:40px 0}

.page-card{
    width:1100px;max-width:95%;background:#fff;border-radius:16px;
    padding:40px;box-shadow:0 10px 25px rgba(0,123,255,.15);position:relative
}

.page-header{text-align:center;margin-bottom:40px}
.page-header img{width:64px;margin-bottom:12px}
.page-header h1{font-size:26px;color:#0d47a1}
.page-header p{font-size:14px;color:#5f7da3}

.form-card{
    max-width:420px;margin:0 auto;background:#f8fbff;
    padding:30px;border-radius:14px;border:1px solid #dbe8f7
}

input,button{
    width:100%;padding:14px;margin-bottom:15px;
    border-radius:30px;border:1px solid #ccc;font-size:14px
}

input[type="file"]{
    padding:10px;background:#fff
}

button{
    background:linear-gradient(135deg,#64b5f6,#1e88e5);
    color:#fff;border:none;cursor:pointer
}

.error{color:#e53935;font-size:13px;text-align:center;margin-bottom:10px}

/* modal */
.modal{
    position:fixed;top:0;left:0;width:100%;height:100%;
    background:rgba(0,0,0,.4);display:none;
    justify-content:center;align-items:center
}

.modal-box{
    background:#fff;padding:30px;border-radius:14px;
    width:360px;text-align:center
}

.modal-box h3{color:#0d47a1;margin-bottom:10px}
.modal-box p{font-size:14px;color:#5f7da3;margin-bottom:20px}

.modal-box button{
    padding:12px 22px;border-radius:30px;border:none;
    background:#1e88e5;color:#fff;cursor:pointer
}
</style>
</head>
<body>

<div class="page-card">

    <div class="page-header">
        <img src="votinglogo.jpg" alt="logo">
        <h1>Add new candidate</h1>
        <p>fill in candidate details to include them in voting</p>
    </div>

    <div class="form-card">
        <?php if($message): ?>
            <div class="error"><?php echo $message; ?></div>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data">
            <input type="text" name="name" placeholder="candidate name">
            <input type="text" name="position" placeholder="position">
            <input type="file" name="image" accept="image/*">
            <button type="submit">Add candidate</button>
        </form>
    </div>

</div>

<?php if($successName): ?>
<div class="modal" id="successModal">
    <div class="modal-box">
        <h3>Candidate added</h3>
        <p>You have successfully added <strong><?php echo $successName; ?></strong></p>
        <button onclick="closeModal()">Continue</button>
    </div>
</div>
<?php endif; ?>

<script>
<?php if($successName): ?>
document.getElementById("successModal").style.display = "flex";
<?php endif; ?>

function closeModal(){
    window.location.href = "votings.php";
}
</script>

</body>
</html>
